/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.pool.Pool;
import net.skinsrestorer.shadow.mariadb.pool.Pools;

public class MariaDbPoolDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource,
Closeable,
AutoCloseable {
    private Pool pool;
    private Configuration conf = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private Integer loginTimeout = null;

    public MariaDbPoolDataSource() {
    }

    public MariaDbPoolDataSource(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong mariaDB url: %s", url));
        }
        this.url = url;
        this.conf = Configuration.parse(url);
        this.pool = Pools.retrievePool(this.conf);
    }

    private void config() throws SQLException {
        if (this.url == null) {
            throw new SQLException("url not set");
        }
        this.conf = Configuration.parse(this.url);
        if (this.loginTimeout != null) {
            this.conf.connectTimeout(this.loginTimeout * 1000);
        }
        if (this.user != null || this.password != null) {
            this.conf = this.conf.clone(this.user, this.password);
        }
        if (this.user != null) {
            this.user = this.conf.user();
        }
        if (this.password != null) {
            this.password = this.conf.password();
        }
        this.pool = Pools.retrievePool(this.conf);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection(username, password).getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("Datasource is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        if (this.loginTimeout != null) {
            return this.loginTimeout;
        }
        if (this.conf != null) {
            return this.conf.connectTimeout() / 1000;
        }
        return DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() : 30;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
        if (this.conf != null) {
            this.config();
        }
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection();
    }

    @Override
    public PooledConnection getPooledConnection(String username, String password) throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection(username, password);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection();
    }

    @Override
    public XAConnection getXAConnection(String username, String password) throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection(username, password);
    }

    public void setUrl(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong mariaDB url: %s", url));
        }
        this.url = url;
        this.config();
    }

    public String getUrl() {
        if (this.conf == null) {
            return this.url;
        }
        return this.conf.initialUrl();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) throws SQLException {
        this.user = user;
        if (this.conf != null) {
            this.config();
        }
    }

    public void setPassword(String password) throws SQLException {
        this.password = password;
        if (this.conf != null) {
            this.config();
        }
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public String getPoolName() {
        return this.pool != null ? this.pool.getPoolTag() : null;
    }

    public List<Long> testGetConnectionIdleThreadIds() {
        return this.pool != null ? this.pool.testGetConnectionIdleThreadIds() : null;
    }
}

